#include "bd.h"

par_t *new_par(par_t *template) 
{
    par_t *par;
    int i;
    
    par=malloc(sizeof(par_t));
    par->text=(unsigned char *)malloc(MAXPARCHARS);
    par->vistext=(unsigned char *)malloc(MAXPARCHARS);
    par->v2l=(guint16 *)malloc(MAXPARCHARS*sizeof(guint16));
    par->xpos=(int *)malloc(MAXPARCHARS*sizeof(int));
    par->cfont=(int *)malloc(MAXPARCHARS*sizeof(int));
    par->text[0]=0;
    if(template==NULL) {
        par->font=fonts[0]; 
        par->style=0;
        par->par_point_width=WIDTH;
        par->par_point_margin=0;
        par->numfontchanges=1;
        par->fontchange[0]=0;
        par->fontchangepos[0]=0;        
        par->lineskip=0;
        par->firstlineskip=0;
        par->firstlineindent=18;
        par->numtabs=4;
        par->tabs[0]=144;
        par->tabs[1]=288;
        par->tabs[2]=432;
        par->tabs[3]=576;
    } else {
        par->font=fonts[template->fontchange[template->numfontchanges-1]];
        par->style=template->style;
        par->par_point_width=template->par_point_width;
        par->par_point_margin=template->par_point_margin;
        par->numfontchanges=1;
        par->fontchange[0]=0;
        par->fontchangepos[0]=template->fontchange[template->numfontchanges-1];
        par->lineskip=template->lineskip;
        par->firstlineskip=template->firstlineskip;
        par->firstlineindent=template->firstlineindent;
        par->numtabs=template->numtabs;
        for(i=0;i<par->numtabs;i++)par->tabs[i]=template->tabs[i];
    }
    
    for(i=0;i<100;i++)par->lines[i]=NULL;
    par->next=NULL;
    par->prev=NULL;

    par->numlines=0;
    
    par->cacheflags=0;

    break_paragraph(par,0,DPI);
    
    return par;
}

int insert_par(par_t *par,par_t *item) {
/* 3 cases: 
    item==first_par - insert before first paragraph
    item==NULL - insert at the end (after last paragraph).
    else - insert before item
*/
    par_t *tmp;
    
    if(last_par==NULL) {
        last_par=par;
        first_par=par;
        par->prev=NULL;
        par->next=NULL;        
    } else if(item==NULL) {
        par->next=NULL;
        last_par->next=par;
        par->prev=last_par;
        last_par=par;
    } else if(item==first_par) {
        first_par=par;
        par->next=item;
        item->prev=par;
        par->prev=NULL;
    } else {
        tmp=item->prev;
        
        item->prev=par;
        tmp->next=par;
        par->prev=tmp;
        par->next=item;
    }
    
    if(par==first_par) {
        par->par_point_ypos=0;
    } else {
        par->par_point_ypos=par->prev->par_point_ypos+par->prev->numlines*par->prev->line_point_height;
    }
    return 0;
}

void free_par(par_t *par) {
    int i;
    free(par->text);
    free(par->vistext);
    free(par->v2l);
    free(par->xpos);
    free(par->cfont);
    for(i=0;i<100;i++)if(par->lines[i]!=NULL)free(par->lines[i]);
    free(par);
}

int del_par(par_t *par) {
    if(par==first_par) {
        if(first_par==last_par) {
            first_par=NULL;
            last_par=NULL;
        } else {
            first_par=par->next;
            first_par->prev=NULL;
        }
    } else if(par==last_par) {
        last_par=par->prev;
        last_par->next=NULL;
    } else {
        par->prev->next=par->next;
        par->next->prev=par->prev;
    }
    free_par(par);
    return 0;
}

par_t *dup_par(par_t *par, int from, int to) {
    par_t *new;
    int i,j;
    
    new=new_par(par);
    strncpy(new->text,par->text+from, to-from);
    new->text[to-from]=0;
    i=fontof(par,from);
    j=0;
    while((i<par->numfontchanges) && ((new->fontchangepos[i]<to) || (j==0))) {
        new->fontchange[j]=par->fontchange[i];
        new->fontchangepos[j]=par->fontchangepos[i]-from;
        i++;
        j++;
    }
    new->fontchangepos[0]=0;
    new->numfontchanges=j;
    return new;
}

